/*********************************************************************
*                                                                    *
*                       Software License Agreement                   *
*                                                                    *
*   The software supplied herewith by Microchip Technology           *
*   Incorporated (the "Company") for its dsPIC controller            *
*   is intended and supplied to you, the Company's customer,         *
*   for use solely and exclusively on Microchip dsPIC                *
*   products. The software is owned by the Company and/or its        *
*   supplier, and is protected under applicable copyright laws. All  *
*   rights are reserved. Any use in violation of the foregoing       *
*   restrictions may subject the user to criminal sanctions under    *
*   applicable laws, as well as to civil liability for the breach of *
*   the terms and conditions of this license.                        *
*                                                                    *
*   THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION.  NO           *
*   WARRANTIES, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING,    *
*   BUT NOT LIMITED TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND    *
*   FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE     *
*   COMPANY SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL,  *
*   INCIDENTAL OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.  *
*                                                                    *
*********************************************************************/

/******************************************************************************
**
**  Filename:     g711.h
**
**  System:       RISC
**
**  Platform:     dsPIC33F
**
**  Description:  This file defines the data types and the function protytpes.
**
******************************************************************************/

#ifndef G711_defined
#define G711_defined 301

/*-----------------------------------------------------------------------------
           Smart function prototypes for [ag]cc, VaxC, and [tb]cc
-----------------------------------------------------------------------------*/
#if !defined(ARGS)
#if (defined(__STDC__) || defined(VMS) || defined(__DECC)  || defined(MSDOS) || defined(__MSDOS__)) || defined (__CYGWIN__) || defined (_MSC_VER)
#define ARGS(s) s
#else
#define ARGS(s) ()
#endif
#endif

/*-----------------------------------------------------------------------------
                       Function prototypes 
-----------------------------------------------------------------------------*/
void  alaw_compress ARGS ( ( long lseg, short *linbuf, unsigned char *logbuf ) );
void  alaw_expand ARGS ( ( long lseg, unsigned char *logbuf, short *linbuf ) );
void  ulaw_compress ARGS ( ( long lseg, short *linbuf, unsigned char *logbuf ) );
void  ulaw_expand ARGS ( ( long lseg, unsigned char *logbuf, short *linbuf ) );

/*-----------------------------------------------------------------------------
                    PREPROCESSOR CONSTANTS/MACROS
-----------------------------------------------------------------------------*/
#define IS_LIN 1
#define IS_LOG 0

#endif

/*-----------------------------------------------------------------------------
                      END OF FILE:  g711.h
-----------------------------------------------------------------------------*/

